/*
 * Decompiled with CFR 0.152.
 */
package weka.filters;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.TimeSeriesTranslate;
import weka.filters.unsupervised.attribute.TimeSeriesTranslateTest;

public abstract class AbstractTimeSeriesFilterTest
extends AbstractFilterTest {
    protected static final double TOLERANCE = 0.001;

    public AbstractTimeSeriesFilterTest(String name) {
        super(name);
    }

    @Override
    public abstract Filter getFilter();

    public void testDefault() {
        this.testInstanceRange_X(((TimeSeriesTranslate)this.m_Filter).getInstanceRange());
    }

    public void testInstanceRange() {
        this.testInstanceRange_X(-5);
        this.testInstanceRange_X(-2);
        this.testInstanceRange_X(2);
        this.testInstanceRange_X(5);
    }

    public void testFillWithMissing() {
        ((TimeSeriesTranslate)this.m_Filter).setFillWithMissing(true);
        Instances result = this.useFilter();
        AbstractTimeSeriesFilterTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        AbstractTimeSeriesFilterTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            Instance in = this.m_Instances.instance(i);
            Instance out = result.instance(i);
            int j = 0;
            while (j < result.numAttributes()) {
                if (j != 1 && j != 2) {
                    if (in.isMissing(j)) {
                        AbstractTimeSeriesFilterTest.assertTrue("Nonselected missing values should pass through", out.isMissing(j));
                    } else if (result.attribute(j).isString()) {
                        AbstractTimeSeriesFilterTest.assertEquals("Nonselected attributes shouldn't change. " + in + " --> " + out, this.m_Instances.attribute(j).value((int)in.value(j)), result.attribute(j).value((int)out.value(j)));
                    } else {
                        AbstractTimeSeriesFilterTest.assertEquals("Nonselected attributes shouldn't change. " + in + " --> " + out, in.value(j), out.value(j), 0.001);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void testInstanceRange_X(int range) {
        ((TimeSeriesTranslate)this.m_Filter).setInstanceRange(range);
        Instances result = this.useFilter();
        AbstractTimeSeriesFilterTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        AbstractTimeSeriesFilterTest.assertEquals(this.m_Instances.numInstances() - Math.abs(range), result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            Instance in = this.m_Instances.instance(i - (range > 0 ? 0 : range));
            Instance out = result.instance(i);
            int j = 0;
            while (j < result.numAttributes()) {
                if (j != 1 && j != 2) {
                    if (in.isMissing(j)) {
                        AbstractTimeSeriesFilterTest.assertTrue("Nonselected missing values should pass through", out.isMissing(j));
                    } else if (result.attribute(j).isString()) {
                        AbstractTimeSeriesFilterTest.assertEquals("Nonselected attributes shouldn't change. " + in + " --> " + out, this.m_Instances.attribute(j).value((int)in.value(j)), result.attribute(j).value((int)out.value(j)));
                    } else {
                        AbstractTimeSeriesFilterTest.assertEquals("Nonselected attributes shouldn't change. " + in + " --> " + out, in.value(j), out.value(j), 0.001);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNumeric()) {
                    ((TimeSeriesTranslate)this.m_FilteredClassifier.getFilter()).setAttributeIndices("" + (i + 1));
                    ((TimeSeriesTranslate)this.m_FilteredClassifier.getFilter()).setFillWithMissing(true);
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            AbstractTimeSeriesFilterTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(TimeSeriesTranslateTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(AbstractTimeSeriesFilterTest.suite());
    }
}

